#include "obj3d.h"

CObj3d::CObj3d()
{
	m_NbVertices = 0;
	m_pVertices = NULL;
	m_NbFaces = 0;
	m_pFaces = NULL;
	m_bMapping = false;
}

CObj3d::~CObj3d()
{
	if (m_pVertices)
		delete m_pVertices;
	if (m_pFaces)
		delete m_pFaces;
}

VERTEX* CObj3d::AllocVertices(DWORD NbVertices)
{
	if (m_pVertices==NULL)
	{
		m_pVertices = new VERTEX[NbVertices];
		m_NbVertices = NbVertices;
		return m_pVertices;
	}
	return m_pVertices;
}

FACE* CObj3d::AllocFaces(DWORD NbFaces)
{
	if (m_pFaces==NULL)
	{
		m_pFaces = new FACE[NbFaces];
		m_NbFaces = NbFaces;
		return m_pFaces;
	}
	return m_pFaces;
}

void CObj3d::SetMapping()
{
	m_bMapping = true;
}

void CObj3d::fprint(FILE *file)
{
	DWORD Cpt1;

	if (file==NULL)
		return;

	fprintf(file, "#################\n");
	fprintf(file, "##    Object   ##\n");
	fprintf(file, "#################\n");

	if (m_pVertices)
	{

		fprintf(file, "-> This objects has %d %s vertices\n", m_NbVertices,
			(m_bMapping)?"mapped":"not mapped");

		if (m_bMapping==true)
		{
			for(Cpt1=0;Cpt1<m_NbVertices;Cpt1++)
			{
				fprintf(file, "%d> %f %f %f, %f %f\n", Cpt1, m_pVertices[Cpt1].x,
					m_pVertices[Cpt1].y, m_pVertices[Cpt1].z,
					m_pVertices[Cpt1].sow, m_pVertices[Cpt1].tow);
			}
		}
		else
		{
			for(Cpt1=0;Cpt1<m_NbVertices;Cpt1++)
			{
				fprintf(file, "%d> %f %f %f\n", Cpt1, m_pVertices[Cpt1].x,
					m_pVertices[Cpt1].y, m_pVertices[Cpt1].z);
			}
		}
	}

	fprintf(file, "-> This object has %d faces\n", m_NbFaces);
	if (m_pFaces)
	{
		for(Cpt1=0;Cpt1<m_NbFaces;Cpt1++)
		{
			fprintf(file, "%d> %d %d %d\n", Cpt1, m_pFaces[Cpt1].A,
				m_pFaces[Cpt1].B, m_pFaces[Cpt1].C);
		}
	}

	fprintf(file, "#################\n");
	fprintf(file, "## End  Object ##\n");
	fprintf(file, "#################\n\n");
}

VERTEX* CObj3d::GetVertices()
{
	return m_pVertices;
}

FACE* CObj3d::GetFaces()
{
	return m_pFaces;
}


DWORD CObj3d::GetNbVertices()
{
	return m_NbVertices;
}


DWORD CObj3d::GetNbFaces()
{
	return m_NbFaces;
}

bool CObj3d::GetMinMax(VECTOR * pMin, VECTOR * pMax)
{
	DWORD Cpt1;

	if ((pMin==NULL)||(pMax==NULL)||(m_NbVertices==0))
		return false;

	pMax->x = pMin->x = m_pVertices[0].x;
	pMax->y = pMin->y = m_pVertices[0].y;
	pMax->z = pMin->z = m_pVertices[0].z;

	for(Cpt1=1;Cpt1<m_NbVertices;Cpt1++)
	{
		if (m_pVertices[Cpt1].x < pMin->x)
			pMin->x = m_pVertices[Cpt1].x;
		if (m_pVertices[Cpt1].y < pMin->y)
			pMin->y = m_pVertices[Cpt1].y;
		if (m_pVertices[Cpt1].z < pMin->z)
			pMin->z = m_pVertices[Cpt1].z;

		if (m_pVertices[Cpt1].x > pMax->x)
			pMax->x = m_pVertices[Cpt1].x;
		if (m_pVertices[Cpt1].y > pMax->y)
			pMax->y = m_pVertices[Cpt1].y;
		if (m_pVertices[Cpt1].z > pMax->z)
			pMax->z = m_pVertices[Cpt1].z;
	}

	return true;
}

void CObj3d::Translate(VECTOR *pTrans)
{
	DWORD Cpt1;

	if ((pTrans==NULL)||(m_pVertices==NULL))
		return;


	for(Cpt1=0;Cpt1<m_NbVertices;Cpt1++)
	{
		m_pVertices[Cpt1].x += pTrans->x;
		m_pVertices[Cpt1].y += pTrans->y;
		m_pVertices[Cpt1].z += pTrans->z;
	}
}

bool CObj3d::Export(char * szFileName)
{
	FILE *file;
	DWORD Cpt1;
	char szFileMap[256];
	DWORD bMapping;

	if (szFileName==NULL)
		return false;

	sprintf(szFileMap, "%s.vtx", szFileName);
	file = fopen(szFileMap, "wb");
	if (file==NULL)
	{
		fprintf(stderr, "Error while opening file \"%s\" for writing", szFileMap);
		return false;
	}

	// Vtx file : order :
	// - mapping ? DWORD
	// - Nb Vertices DWORD
	// - {Vertex|VertexLight}*(1..n)
	// - {NbFaces DWORD}*(0..1)
	// - {Faces}*(0..n)

	bMapping = m_bMapping;
	fwrite(&bMapping, 4, 1, file);
	fwrite(&m_NbVertices, sizeof(m_NbVertices), 1, file);
	if (m_bMapping)
	{
		fwrite(m_pVertices, sizeof(VERTEX), m_NbVertices, file);
	}
	else
	{
		for(Cpt1=0;Cpt1<m_NbVertices;Cpt1++)
			fwrite(m_pVertices+Cpt1, sizeof(VERTEXLIGHT), 1, file);
	}

	fclose(file);

	sprintf(szFileMap, "%s.face", szFileName);
	file = fopen(szFileMap, "wb");
	if (file==NULL)
		return false;

	fwrite(&m_NbFaces, sizeof(m_NbFaces), 1, file);
	fwrite(m_pFaces, sizeof(FACE), m_NbFaces, file);

	fclose(file);

	return true;
}
